% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anyLib.R
\name{anyLib}
\alias{anyLib}
\title{Install and load any library}
\usage{
anyLib(pkg, force = FALSE, autoUpdate = TRUE, lib = .libPaths()[1],
  loadLib = .libPaths(), source = FALSE)
}
\arguments{
\item{pkg}{The package name or the list containing the packages names.}

\item{force}{To force reinstallation of packages.}

\item{autoUpdate}{To select whether Bioconductor packages auto update or not.}

\item{lib}{Where to install the packages}

\item{loadLib}{From where the packages are loaded}

\item{source}{The package to install is a local source file, on the user disk.}
}
\value{
A named vector of booleans showing if the package is loaded properly
}
\description{
Made to make your life simpler with packages/libraries,
by installing and loading a list of packages, whether they are on CRAN,
Bioconductor or github. For github, if you do not have the full path, with
the maintainer name in it (e.g. "achateigner/topReviGO"), it will not be able
to install it. However, once installed you only need the name of the package.
For more details see the help vignette:
\code{vignette("help", package = "anyLib")}
}
\details{
The source option can be a single TRUE or FALSE, or a vector of TRUE
and FALSE corresponding to the vector/list of packages. E.g. if
source == c(TRUE, FALSE), the first package will be considered as a source
file. The file has to be a tar.gz source file, not a binary.
}
\examples{
# Install and load 1 package from a local source file, which name is in an object:
lib <- normalizePath(tempdir(), "/")
listOfPackages <- system.file("dummyPackage_0.1.0.tar.gz", package="anyLib")
anyLib(listOfPackages, force = TRUE, autoUpdate = FALSE, lib = lib,
loadLib = lib, source = TRUE)
}
