% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orsf.R
\name{orsf_time_to_train}
\alias{orsf_time_to_train}
\title{Estimate training time}
\usage{
orsf_time_to_train(object, n_tree_subset = 50)
}
\arguments{
\item{object}{an untrained \code{aorsf} object}

\item{n_tree_subset}{(\emph{integer})  how many trees should be fit in order
to estimate the time needed to train \code{object}. The default value is 50,
as this usually gives a good enough approximation.}
}
\value{
a \link{difftime} object.
}
\description{
Estimate training time
}
\examples{

# specify but do not train the model by setting no_fit = TRUE.
object <- orsf(pbc_orsf, Surv(time, status) ~ . - id,
               n_tree = 500, no_fit = TRUE)

# grow 50 trees to approximate the time it will take to grow 500 trees
time_estimated <- orsf_time_to_train(object, n_tree_subset = 50)

print(time_estimated)

# let's see how close the approximation was
time_true_start <- Sys.time()
fit <- orsf_train(object)
time_true_stop <- Sys.time()

time_true <- time_true_stop - time_true_start

print(time_true)

# error
abs(time_true - time_estimated)

}
