% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_normalDensity.R
\name{apollo_normalDensity}
\alias{apollo_normalDensity}
\title{Calculates density from a Normal distribution}
\usage{
apollo_normalDensity(normalDensity_settings, functionality)
}
\arguments{
\item{normalDensity_settings}{List of arguments to the functions. It must contain the following.
        \itemize{
          \item outcomeNormal: Numeric vector. Dependant variable.
          \item xNormal: Numeric vector. Single explanatory variable.
          \item mu: Numeric scalar. Intercept of the linear model.
          \item sigma: Numeric scalar. Variance of error component of linear model to be estimated.
\item rows: Boolean vector. Consideration of rows in the likelihood calculation, FALSE to exclude. Length equal to the number of observations (nObs). Default is \code{"all"}, equivalent to \code{rep(TRUE, nObs)}.
        }}

\item{functionality}{Character. Can take different values depending on desired output.
\itemize{
  \item "estimate": Used for model estimation.
  \item "prediction": Used for model predictions.
  \item "validate": Used for validating input.
  \item "zero_LL": Used for calculating null likelihood.
  \item "conditionals": Used for calculating conditionals.
  \item "output": Used for preparing output after model estimation.
  \item "raw": Used for debugging.
}}
}
\value{
The returned object depends on the value of argument \code{functionality} as follows.
        \itemize{
          \item "estimate": vector/matrix/array. Returns the probabilities for the chosen value for each observation.
          \item "prediction": Not applicable.
          \item "validate": Boolean. Returns TRUE if all tests are passed.
          \item "zero_LL": Not applicable.
          \item "conditionals": Same as "estimate".
          \item "output": Same as "estimate" but also writes summary of choices into temporary file (later read by \code{apollo_modelOutput}).
          \item "raw": Same as "estimate".
        }
}
\description{
Calculates density from a Normal distribution at a specific value with a specified mean and standard deviation.
}
\details{
This function estimates the linear model outcomeNormal = mu + xNormal + epsilon, where epsilon is a random error distributed Normal(0,sigma).
If using this function in the context of an Integrated Choice and Latent Variable (ICLV) model with continuous
indicators, then \code{outcomeNormal} would be the value of the indicator, \code{xNormal} would be the value of the latent variable (possibly
multiplied by a parameter to measure its correlation with the indicator, e.g. xNormal=lambda*LV), and \code{mu} would be
an additional parameter to be estimated (the mean of the indicator, which should be fixed to zero if the indicator is
centered around its mean beforehand).
}
\examples{
### Load data
xNormal <- runif(100)
outcomeNormal <- 1 + 2*xNormal + rnorm(100, mean=0, sd=0.5)

### Parameters
b = list(a=1, m=2)

### normalDensity settings
normalDensity_settings <- list(
   outcomeNormal     = outcomeNormal,
   xNormal     = 2*xNormal,
   mu    = 1,
   sigma = 0.5
)

### Compute choice probabilities using normal density
apollo_normalDensity(normalDensity_settings, functionality="estimate")
}
