% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apollo_prediction.R
\name{apollo_prediction}
\alias{apollo_prediction}
\title{Predicts using an estimated model}
\usage{
apollo_prediction(model, apollo_probabilities, apollo_inputs,
  modelComponent = "model")
}
\arguments{
\item{model}{Model object. Estimated model object as returned by function \link{apollo_estimate}.}

\item{apollo_probabilities}{Function. Returns probabilities of the model to be estimated. Must receive three arguments:
\itemize{
  \item apollo_beta: Named numeric vector. Names and values of model parameters.
  \item apollo_inputs: List containing options of the model. See \link{apollo_validateInputs}.
  \item functionality: Character. Can be either "estimate" (default), "prediction", "validate", "conditionals", "zero_LL", or "raw".
}}

\item{apollo_inputs}{List grouping most common inputs. Created by function \link{apollo_validateInputs}.}

\item{modelComponent}{Character. Name of component of apollo_probabilities output to calculate predictions for. Default is "model", i.e. the whole model.}
}
\value{
A vector containing predictions for component \code{modelComponent} of the model described in \code{apollo_probabilities}.
}
\description{
Calculates apollo_probabilities with functionality="prediction" and extracts one element from the returned list.
}
\details{
Structure of predictions are simplified before returning, e.g. list of vectors are turned into a matrix.
}
