% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_apsimx_json.R
\name{inspect_apsimx}
\alias{inspect_apsimx}
\title{Inspect an .apsimx (JSON) file}
\usage{
inspect_apsimx(
  file = "",
  src.dir = ".",
  node = c("Clock", "Weather", "Soil", "SurfaceOrganicMatter", "MicroClimate", "Crop",
    "Manager", "Report", "Operations", "Other"),
  soil.child = c("Metadata", "Water", "InitialWater", "Chemical", "Physical", "Analysis",
    "SoilWater", "InitialN", "CERESSoilTemperature", "Sample", "Nutrient", "Organic",
    "Swim3"),
  parm = NULL,
  digits = 3,
  print.path = FALSE,
  root
)
}
\arguments{
\item{file}{file ending in .apsimx to be inspected (JSON)}

\item{src.dir}{directory containing the .apsimx file to be inspected; defaults to the current working directory}

\item{node}{specific node to be inspected either \sQuote{Clock}, \sQuote{Weather}, 
\sQuote{Soil}, \sQuote{SurfaceOrganicMatter}, \sQuote{MicroClimate}, \sQuote{Crop},
 \sQuote{Manager}, \sQuote{Operations} or \sQuote{Other}}

\item{soil.child}{specific soil component to be inspected. The options vary depending on what is available (see details)}

\item{parm}{parameter to refine the inspection of the \sQuote{manager} list(\sQuote{parm},\sQuote{position}), use \sQuote{NA} for all the positions. \sQuote{parm} can be a regular expression for partial matching.}

\item{digits}{number of decimals to print (default 3). Not used now because everything is a character.}

\item{print.path}{whether to print the path to the specific parameter. Useful to give the later editing. (Also returned as \sQuote{invisible})}

\item{root}{root node label. In simulation structures such as factorials there will be multiple possible nodes. This can be specified by supplying an appropriate character.}
}
\value{
prints a table with inspected parameters and values (and \sQuote{parm path} when \sQuote{print.path} = TRUE).
}
\description{
inspect a JSON apsimx file. It does not replace the GUI, but it can save time by quickly checking parameters and values.
}
\details{
In general, this function is used to inspect one parameter at a time. There are some exceptions. \cr

When node equals \sQuote{Other} there are several options. If \sQuote{parm} is not specified the structure 
of the simulation file will be returned. In this case, the parameter to print is typically just \sQuote{Simulations}.
This option is useful when the intention is to show the simulation structure to pick a root presumably. \sQuote{parm} 
can be set as 0, 1, 2 or 3 for different levels. 
\sQuote{parm} can also be a list with integers, such as \sQuote{list(1, 2, 3)}. If zero is included, available elements
If a parameter is specified the function will try to \sQuote{guess} the root elements from the parameter path supplied.

This is simply a script that prints the relevant parameters which are likely to need editing. It does not print all information from an .apsimx file.
         To investigate the available \sQuote{soil.childs} specify \sQuote{Soil} for \sQuote{node} and do not specify the \sQuote{soil.child}.
}
\examples{
\donttest{
extd.dir <- system.file("extdata", package = "apsimx")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Clock") 
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Weather")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "Metadata") 
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "Physical") 
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "SoilWater") 
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "Organic")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "Chemical")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "InitialWater")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Soil", soil.child = "InitialN")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "SurfaceOrganicMatter")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "MicroClimate")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Crop")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Manager")
inspect_apsimx("Wheat.apsimx", src.dir = extd.dir, node = "Report")

## Examples of using node = "Other"
extd.dir <- system.file("extdata", package = "apsimx")

## When parm is not provided
inspect_apsimx("maize-manager-folder.apsimx", src.dir = extd.dir, node = "Other")
## When parm = 2
inspect_apsimx("maize-manager-folder.apsimx", src.dir = extd.dir, 
               node = "Other", parm = 2)
## When parm = 3
inspect_apsimx("maize-manager-folder.apsimx", src.dir = extd.dir, 
               node = "Other", parm = 3)
## When parm is a path
inspect_apsimx("maize-manager-folder.apsimx", src.dir = extd.dir, 
               node = "Other", parm = ".Simulations.Simulation")
## When parm is a list with numbers (integers)
pp <- inspect_apsimx("maize-manager-folder.apsimx", src.dir = extd.dir, 
                     node = "Other", parm = list(1, 1, 5), 
                     print.path = TRUE)
## Same as above, but with zero prints possible options
inspect_apsimx("maize-manager-folder.apsimx", src.dir = extd.dir, 
                node = "Other", parm = list(1, 1, 5, 0))

## It is possible to look into folders using this method           
inspect_apsimx("maize-manager-folder.apsimx", node = "Other", src.dir = extd.dir,
               parm = list("Manager", "Fertiliser", "Amount"))


               
}

}
