% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/duplicate.R
\name{duplicate}
\alias{duplicate}
\title{Duplicte Profiles of a SoilProfileColection}
\usage{
duplicate(x, times = 3, oldID = ".oldID")
}
\arguments{
\item{x}{a \code{SoilProfileCollection} object with 1 or more profiles}

\item{times}{requested number of copies}

\item{oldID}{site-level attribute used to store the original profile IDs}
}
\value{
a \code{SoilProfileCollection} object
}
\description{
A simple function to duplicate the contents of a \code{SoilProfileColection} object. Old profile IDs are saved as a site-level attribute (\code{oldID}) and new IDs are generated using a numeric serial number.
}
\note{
Duplication is also possible with \code{permute_profile} and \code{sim} by simulation from 0-variance distributions. This is a simpler, likely faster, alternative when duplication vs. simulation is required.
}
\examples{

# sample data
data('sp4')

# promote to SPC
depths(sp4) <- id ~ top + bottom

# duplicate each profile 2 times
d <- duplicate(sp4, times = 2)

# graphical check
par(mar = c(0, 0, 3, 1))
plotSPC(d, color = 'Ca', width = 0.25)

}
\author{
D.E. Beaudette
}
\keyword{manip}
