% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SoilProfileCollection-setters.R
\docType{methods}
\name{diagnostic_hz<-}
\alias{diagnostic_hz<-}
\alias{diagnostic_hz<-,SoilProfileCollection-method}
\title{Add data to the diagnostic slot}
\usage{
diagnostic_hz(object) <- value
}
\arguments{
\item{object}{A SoilProfileCollection}

\item{value}{An object inheriting \code{data.frame}}
}
\description{
Diagnostic data in an object inheriting from \code{data.frame} can easily be added via merge (LEFT JOIN). There must be one or more same-named columns containing profile ID on the left and right hand side to facilitate the join: \code{diagnostic_hz(spc) <- newdata}
}
\examples{

# load test data
data(sp2)

# promote to SPC
depths(sp2) <- id ~ top + bottom

# assign two profiles a zone related to the mollic epipedon
newdata <- data.frame(id = c("hon-1","hon-17"),
                      featkind = "fixed-depth surface sample",
                      featdept = 0,
                      featdepb = 18)

# do left join
diagnostic_hz(sp2) <- newdata

# inspect site table: newvalue TRUE only for horizons
#  with top depth equal to zero
diagnostic_hz(sp2)

}
