% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadots.R
\name{.data_dots}
\alias{.data_dots}
\title{Make a data.frame from non-standard expressions evaluated in a data environment}
\usage{
.data_dots(.data, ...)
}
\arguments{
\item{.data}{A list, or object coercible to one, describing the data}

\item{...}{One or more expressions (preferably named e.g. \code{foo = "bar"}) to evaluate in \code{.data}}
}
\value{
A \code{list} where names are expression "names" from \code{...} and values are the result of evaluating expressions in context of \code{.data}
}
\description{
Make a data.frame from non-standard expressions evaluated in a data environment
}
\examples{
# .data_dots(data.frame(a = 1:10, b = 2:11), cc = a + b, d = cc * 2)
# data("jacobs2000", package="aqp")
# .data_dots(compositeSPC(jacobs2000), clayprop = clay / 100)

}
