% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\docType{data}
\name{sp1}
\alias{sp1}
\title{Soil Profile Data Example 1}
\format{
A data frame with 60 observations on the following 21 variables.
\describe{ \item{group}{a numeric vector} \item{id}{a
character vector} \item{top}{a numeric vector}
\item{bottom}{a numeric vector} \item{bound_distinct}{a
character vector} \item{bound_topography}{a character vector}
\item{name}{a character vector} \item{texture}{a character
vector} \item{prop}{a numeric vector}
\item{structure_grade}{a character vector}
\item{structure_size}{a character vector}
\item{structure_type}{a character vector}
\item{stickiness}{a character vector} \item{plasticity}{a
character vector} \item{field_ph}{a numeric vector}
\item{hue}{a character vector} \item{value}{a numeric
vector} \item{chroma}{a numeric vector} }
}
\description{
Soil profile data from Pinnacles National Monument, CA.
}
\examples{

data(sp1)
# convert colors from Munsell to hex-encoded RGB
sp1$soil_color <- with(sp1, munsell2rgb(hue, value, chroma))

# promote to SoilProfileCollection
depths(sp1) <- id ~ top + bottom
site(sp1) <- ~ group

# re-sample each profile into 1 cm (thick) depth slices
# for the variables 'prop', 'name', 'soil_color'
# result is a SoilProfileCollection object
s <- slice(sp1, 0:25 ~ prop + name + soil_color)

# plot, note slices
plot(s)


# aggregate all profiles along 1 cm depth slices,
# using data from column 'prop'
s1 <- slab(sp1, fm= ~ prop)

# check median & IQR
library(lattice)
xyplot(top ~ p.q50 + p.q25 + p.q75,
data=s1, type='S', horizontal=TRUE, col=1, lty=c(1,2,2),
panel=panel.superpose, ylim=c(110,-5), asp=2)


}
\references{
http://casoilresource.lawr.ucdavis.edu/
}
\keyword{datasets}
