% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor-level-setters.R
\name{SoilTextureLevels}
\alias{SoilTextureLevels}
\title{Ranking Systems for USDA Soil Texture Classes}
\usage{
SoilTextureLevels(which = "codes", simplify = FALSE)
}
\arguments{
\item{which}{'codes' (texture codes) or 'names' (texture class names)}

\item{simplify}{Return 12-class factor levels (\code{TRUE}) or 21-class factor levels (default: \code{FALSE})? The 12-class system does not separate sands, loamy sands and sandy loams into sand fraction variants (e.g. "very fine sandy loam" in the 21-class system is "sandy loam" in 12-class system)}
}
\value{
an ordered factor
}
\description{
Generate a vector of USDA soil texture codes or class names, sorted according to approximate particle size
}
\examples{

# class codes
SoilTextureLevels()

# class names
SoilTextureLevels(which = 'names')

# simpler class names
SoilTextureLevels(which = 'names', simplify = TRUE)
 
}
\references{
\href{https://nrcspad.sc.egov.usda.gov/DistributionCenter/product.aspx?ProductID=991}{Field Book for Describing and Sampling Soils, version 3.0}
}
