% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dom_overzicht.R
\name{dom_overzicht}
\alias{dom_overzicht}
\title{Overzicht van alle domeintabellen}
\usage{
dom_overzicht(peildatum = Sys.Date())
}
\arguments{
\item{peildatum}{Date of een character die omgezet kan worden in een Date met
\code{lubridate::as_date()}. De peildatum filtert de output om alleen geldige
domeintabellen op de peildatum weer te geven. Gebruik \code{NULL} om alle
domeintabellen ongeacht de geldigheid weer te geven.}
}
\value{
Een tibble met een overzicht van alle domeintabellen. Het overzicht
bevat de volgende kolommen:
\itemize{
\item \code{domeintabel} - Naam van de domeintabel.
\item \code{domeintabelsoort} - Het type domeintabel.
\item \code{wijzigingsdatum} - Datum van de laatste wijziging van de tabel.
\item \code{begin_geldigheid} - Datum van het begin van de geldigheid van de domeintabel.
\item \code{eind_geldigheid} - Datum van het eind van de geldigheid van de domeintabel.
\item \code{kolommen} - Een vector met de kolomnamen van de domeintabel.
\item \code{guid} - De guid van de domeintabel.
}
}
\description{
Deze functie geeft een overzicht van alle beschikbare domeintabellen,
inclusief historische tabellen, op www.aquo.nl.
}
\section{Caching}{
 Deze functie maakt gebruik van caching voor het
optimaliseren van snelheid en om de aquo-server niet onnodig te belasten.
Hiervoor wordt de map \code{tempdir()} gebruikt als cache. Deze map wordt na
elke R-sessie verwijderd.
}

\examples{
\dontrun{

dom_overzicht()
dom_overzicht(peildatum = Sys.Date())
dom_overzicht(peildatum = "2021-04-05")

}
}
\seealso{
Other domeintabellen: 
\code{\link{dom_save}()},
\code{\link{dom}()}
}
\concept{domeintabellen}
