% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{predict.RuleModel}
\alias{predict.RuleModel}
\title{Apply Rule Model}
\usage{
\method{predict}{RuleModel}(object, newdata, ...)
}
\arguments{
\item{object}{a \link{RuleModel} class instance}

\item{newdata}{a data frame with data}

\item{...}{other arguments (currently not used)}
}
\value{
A vector with predictions.
}
\description{
Method that matches rule model against test data.
}
\examples{
  train <- datasets::iris[1:100,]
  test <- datasets::iris[101:length(datasets::iris),]
  #increase for more accurate results in longer time
  target_rule_count <- 1000
  classatt <- "Species"
  rm <- cba(train, classatt, list(target_rule_count = target_rule_count))
  prediction <- predict(rm, test)
  acc <- rulemodelAccuracy(prediction, test[[classatt]])
  message(acc)
}
\seealso{
\link{cbaIris}
}

