% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{predict.CBARuleModel}
\alias{predict.CBARuleModel}
\title{Apply Rule Model}
\usage{
\method{predict}{CBARuleModel}(object, data, discretize = TRUE, ...)
}
\arguments{
\item{object}{a \link{CBARuleModel} class instance}

\item{data}{a data frame with data}

\item{discretize}{boolean indicating whether the passed data should be discretized
using information in the passed @cutp slot of the ruleModel argument.}

\item{...}{other arguments (currently not used)}
}
\value{
A vector with predictions.
}
\description{
Method that matches rule model against test data.
}
\examples{
  allData<-datasets::iris[sample(nrow(datasets::iris)),]
  trainFold <- allData[1:100,]
  testFold <- allData[101:nrow(allData),]
  #increase for more accurate results in longer time
  target_rule_count <- 1000
  classAtt <- "Species"
  rm <- cba(trainFold, classAtt, list(target_rule_count = target_rule_count))
  prediction <- predict(rm, testFold)
  acc <- CBARuleModelAccuracy(prediction, testFold[[classAtt]])
  message(acc)
}
\seealso{
\link{cbaIris}
}
