% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cba.R
\name{cba}
\alias{cba}
\title{CBA Classifier}
\usage{
cba(train, classAtt, rulelearning_options = NULL, pruning_options = NULL)
}
\arguments{
\item{train}{a data frame with data.}

\item{classAtt}{the name of the class attribute.}

\item{rulelearning_options}{custom options for the rule learning algorithm overriding the default values.}

\item{pruning_options}{custom options for the pruning algorithm overriding the default values.}
}
\value{
Object of class \link{CBARuleModel}.
}
\description{
Learns a CBA rule set from supplied dataframe.
}
\examples{
 # Example using automatic threshold detection
  cba(datasets::iris, "Species", rulelearning_options = list(target_rule_count = 50000))
 # Example using manually set confidence and support thresholds
  rm <- cba(datasets::iris, "Species", rulelearning_options = list(minsupp=0.01,
   minconf=0.5, minlen=1, maxlen=5, maxtime=1000, target_rule_count=50000, trim=TRUE,
   find_conf_supp_thresholds=FALSE))
  inspect(rm@rules)
}
