% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-feature-server.R
\name{get_layer}
\alias{get_layer}
\alias{get_all_layers}
\alias{get_layers}
\title{Extract a layer from a Feature or Map Server}
\usage{
get_layer(x, id = NULL, name = NULL, token = arc_token())

get_all_layers(x, token = arc_token())

get_layers(x, id = NULL, name = NULL, token = arc_token())
}
\arguments{
\item{x}{an object of class \code{FeatureServer} or \code{MapServer}}

\item{id}{default \code{NULL}. A numeric vector of unique ID of the layer you want to retrieve. This is a scalar in \code{get_layer()}.}

\item{name}{default \code{NULL}. The name associated with the layer you want to retrieve. \code{name} is mutually exclusive with \code{id}. This is a scalar in \code{get_layer()}.}

\item{token}{your authorization token.}
}
\value{
\itemize{
\item \code{get_layer()} returns a single \code{FeatureLayer} or \code{Table} based on its ID
\item \code{get_layers()} returns a list of the items specified by the \code{id} or \code{name} argument
\item \code{get_all_layers()} returns a named \code{list} with an element \code{layers} and \code{tables}.
Each a list containing \code{FeatureLayer} and \code{Table}s respectively.
}
}
\description{
These helpers provide easy access to the layers contained in a
\code{FeatureServer} or \code{MapServer}.
}
\details{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{id} and \code{name} arguments must match the field values of the respective names as seen in the output of \code{list_items()}
}
\examples{
\dontrun{
  # FeatureServer
  furl <- paste0(
    "https://services3.arcgis.com/ZvidGQkLaDJxRSJ2/arcgis/rest/services/",
    "PLACES_LocalData_for_BetterHealth/FeatureServer"
  )

  fserv <- arc_open(furl)

  fserv
  get_layer(fserv, 0)
  get_layers(fserv, name = c("Tracts", "ZCTAs"))
  get_all_layers(fserv)
}
}
