% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/zipRepo.R
\name{zipLocalRepo}
\alias{zipGithubRepo}
\alias{zipLocalRepo}
\title{Create a zip Archive From an Existing Repository}
\usage{
zipLocalRepo(repoDir = NULL, repoTo = getwd(), zipname = "repository.zip")

zipGithubRepo(repoTo = getwd(), user = NULL, repo = NULL,
  branch = "master", repoDirGit = FALSE, zipname = "repository.zip")
}
\arguments{
\item{repoDir}{A character that specifies the directory of the Repository which
will be zipped. If set to \code{NULL} (by default), uses the \code{repoDir} specified in \link{setLocalRepo}.}

\item{repoTo}{A character that specifies the directory in which
will be created zip archive from \code{Repository} stored in \code{repoDir} or Github directory.
By default set to working directory (\code{getwd()})/}

\item{zipname}{A character that specifies name of zipped repository.
It is assumed that this file does not exist or does not contain backpack.db file.
An attempt to override will produce an error.}

\item{user}{Only if working with a Github repository. A character containing a name of a Github user on whose account the \code{repo} is created.
By default set to \code{NULL} - see \code{Note}.}

\item{repo}{Only if working with a Github repository. A character containing a name of a Github repository on which the Repository to be zipped is archived.
By default set to \code{NULL} - see \code{Note}.}

\item{branch}{Only if working with a Github repository. A character containing a name of
Github repository's branch in which Repository to be zipped is archived. Default \code{branch} is \code{master}.}

\item{repoDirGit}{Only if working with a Github repository. A character containing a name of a directory on Github repository
on which the Repository to be zipped is stored. If the Repository is stored in main folder on Github repository, this should be set
to \code{repoDirGit = FALSE} as default.}
}
\description{
\code{zipLocalRepo} and \code{zipGithubRepo} create a zip archive from an existing \link{Repository}.



If the function does not work, it might be a reason of Rtools that are not installed.
To solve this problem follow those \href{http://cran.r-project.org/web/packages/openxlsx/vignettes/Introduction.pdf}{Instructions.}
}
\details{
\code{zipLocalRepo} and \code{zipGithubRepo} create a zip archive from an existing \link{Repository}.
\code{zipLocalRepo} zips local \code{Repository}, \code{zipGithubRepo} zips \code{Repository}
stored on Github.
}
\note{
If the function does not work, it might be a reason of Rtools that are not installed.
To solve this problem follow those \href{http://cran.r-project.org/web/packages/openxlsx/vignettes/Introduction.pdf}{Instructions.}

If \code{repo} and \code{user} are set to \code{NULL} (as default) in Github mode then global parameters
set in \link{setGithubRepo} function are used.
}
\examples{
# objects preparation
\dontrun{
# data.frame object
data(iris)

# ggplot/gg object
library(ggplot2)
df <- data.frame(gp = factor(rep(letters[1:3], each = 10)),y = rnorm(30))
library(plyr)
ds <- ddply(df, .(gp), summarise, mean = mean(y), sd = sd(y))
myplot123 <- ggplot(df, aes(x = gp, y = y)) +
  geom_point() +  geom_point(data = ds, aes(y = mean),
               colour = 'red', size = 3)

# lm object
model <- lm(Sepal.Length~ Sepal.Width + Petal.Length + Petal.Width, data= iris)

# Local version

exampleRepoDir <- tempdir()
createEmptyRepo( repoDir = exampleRepoDir )
saveToRepo( myplot123, repoDir=exampleRepoDir )
saveToRepo( iris, repoDir=exampleRepoDir )
saveToRepo( model, repoDir=exampleRepoDir )



zipLocalRepo( exampleRepoDir )

deleteRepo( exampleRepoDir, TRUE)

rm( exampleRepoDir )

# Github version

zipGithubRepo( user="MarcinKosinski",
repo="Museum", branch="master", repoDirGit="ex1" )

zipGithubRepo( user="pbiecek", repo="archivist", repoTo = getwd( ) )

}
}
\author{
Marcin Kosinski, \email{m.p.kosinski@gmail.com}, Przemyslaw Biecek
}
\seealso{
Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}}

Other archivist: \code{\link{Repository}};
  \code{\link{Tags}}; \code{\link{\%a\%}};
  \code{\link{addTagsRepo}}; \code{\link{ahistory}},
  \code{\link{print.ahistory}}; \code{\link{aoptions}};
  \code{\link{archivist-package}}; \code{\link{aread}};
  \code{\link{asearch}}; \code{\link{cache}};
  \code{\link{copyGithubRepo}},
  \code{\link{copyLocalRepo}};
  \code{\link{createEmptyRepo}}; \code{\link{deleteRepo}};
  \code{\link{getTagsGithub}}, \code{\link{getTagsLocal}};
  \code{\link{loadFromGithubRepo}},
  \code{\link{loadFromLocalRepo}}; \code{\link{md5hash}};
  \code{\link{multiSearchInGithubRepo}},
  \code{\link{multiSearchInLocalRepo}},
  \code{\link{searchInGithubRepo}},
  \code{\link{searchInLocalRepo}};
  \code{\link{rmFromRepo}}; \code{\link{saveToRepo}};
  \code{\link{setGithubRepo}}, \code{\link{setLocalRepo}};
  \code{\link{shinySearchInLocalRepo}};
  \code{\link{showGithubRepo}},
  \code{\link{showLocalRepo}};
  \code{\link{summaryGithubRepo}},
  \code{\link{summaryLocalRepo}}
}

