% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addArchivistHooks.R
\name{addHooksToPrint}
\alias{addHooksToPrint}
\title{Add Archivist Hooks to Report}
\usage{
addHooksToPrint(class = "ggplot", repoDir = aoptions("repoDir"),
  repo = aoptions("repo"), user = aoptions("user"), branch = "master",
  subdir = aoptions("subdir"))
}
\arguments{
\item{class}{A character containing a name of class (one or more) that should be archivised.}

\item{repoDir}{A character containing a name of Local Repository.}

\item{repo}{A character containing a name of a Git repository on which the Repository is archived.
If \code{repo = NULL} then hooks will be added to files in local directories.}

\item{user}{A character containing a name of a Git user on whose account the \code{repo} is created.}

\item{branch}{A character containing a name of Git Repository's branch on which the Repository is archived. 
Default \code{branch} is \code{master}.}

\item{subdir}{A character containing a name of a directory on Git repository 
on which the Repository is stored. If the Repository is stored in main folder on Git repository, this should be set 
to \code{subdir = "/"} as default.}
}
\description{
\code{addHooksToPrint} adds an overloaded version of the print function for objects of selected class. 
The overloaded function will add all object of selected class to the repo and then add hooks to the report for these objects .
}
\note{
One can specify \code{userTags} as in \link{saveToLocalRepo} for artifacts by adding code{"tags"} attribute.
See note secion about that in \link{saveToLocalRepo}.
}
\examples{

\dontrun{
# only in Rmd report, links to github repository
addHooksToPrint(class="ggplot", repoDir = "arepo",
repo="graphGallery", user="pbiecek")
# only in Rmd report, links to local files
addHooksToPrint(class="ggplot", repoDir = "arepo",
repo=NULL)
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addTagsRepo}}, \code{\link{aformat}},
  \code{\link{ahistory}}, \code{\link{alink}},
  \code{\link{aoptions}}, \code{\link{archivist-package}},
  \code{\link{aread}}, \code{\link{asearch}},
  \code{\link{asession}}, \code{\link{cache}},
  \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

