% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atrace.R
\name{atrace}
\alias{atrace}
\title{Add Tracing For All Objects Created By Given Function}
\usage{
atrace(FUN = "lm", object = "z")
}
\arguments{
\item{FUN}{name of a function to be traced (character)}

\item{object}{name of an object that should be traced (character)}
}
\description{
\code{atrace} add call to \link{saveToLocalRepo} at the end of a given function.
}
\details{
Function \code{atrace} calls the \link{trace} function.
}
\examples{
# read the object from local directory
createLocalRepo("arepo_test", default=TRUE)
atrace("lm", "z")
lm(Sepal.Length~Sepal.Width, data=iris)
asearch("class:lm")
untrace("lm")
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\seealso{
Other archivist: \code{\link{Repository}},
  \code{\link{Tags}}, \code{\link{\%a\%}},
  \code{\link{addHooksToPrint}}, \code{\link{addTagsRepo}},
  \code{\link{aformat}}, \code{\link{ahistory}},
  \code{\link{alink}}, \code{\link{aoptions}},
  \code{\link{archivist-package}}, \code{\link{aread}},
  \code{\link{asearch}}, \code{\link{asession}},
  \code{\link{cache}}, \code{\link{copyLocalRepo}},
  \code{\link{createLocalRepo}},
  \code{\link{createMDGallery}},
  \code{\link{deleteLocalRepo}},
  \code{\link{getRemoteHook}}, \code{\link{getTagsLocal}},
  \code{\link{loadFromLocalRepo}}, \code{\link{md5hash}},
  \code{\link{restoreLibs}}, \code{\link{rmFromLocalRepo}},
  \code{\link{saveToLocalRepo}},
  \code{\link{searchInLocalRepo}},
  \code{\link{setLocalRepo}},
  \code{\link{shinySearchInLocalRepo}},
  \code{\link{showLocalRepo}},
  \code{\link{splitTagsLocal}},
  \code{\link{summaryLocalRepo}},
  \code{\link{zipLocalRepo}}
}

