% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setVariables.R
\name{setVariables}
\alias{setVariables}
\title{Set index and translation tables}
\usage{
setVariables(
  input = NULL,
  variable = NULL,
  type = "both",
  pid = NULL,
  origin = NULL,
  target = NULL
)
}
\arguments{
\item{input}{[\code{tibble(1)}]\cr a possibly already existing table based on
which the output should be constructed; see details.}

\item{variable}{[\code{character(1)}]\cr name of the variable and thus of the
output file(s).}

\item{type}{[\code{character(1)}]\cr the type of table to create, either an
index (\code{"id"}), a translation table (\code{"tt"}) or \code{"both"}
(default).}

\item{pid}{[\code{character(1)}]\cr column in \code{input} that contains the
primary ID for the index table. If this is not given, an ID name is created
as \code{paste0(str_sub(variable, 1, 3), "ID")}}

\item{origin}{[\code{character(1)}]\cr column in \code{input} that contains
terms that shall be translated.}

\item{target}{[\code{character(1)}]\cr column in \code{input} that contains
the standardised terms.}
}
\value{
No return value, called for the side effect of writing a table to the
  project root directory with name \code{paste0(type, "_", variable,
  ".csv")}.
}
\description{
Use a pre-compiled table to create an index and/or translation table for the
target variables of an areal database.
}
\details{
This is the second function that is run in a project, as it creates
  index and translation tables for the target variables that shall be stored
  in an areal database. \itemize{ \item An index table relates an ID (given
  in \code{pid}) to the variable terms (given in \code{target}) and
  potentially to ancillary information. Such tables should be compiled before
  a project is started and should contain a clear set of values per variable
  (which will be used as standard vocabulary). \item A translation table
  relates terms in foreign languages (given in \code{origin}) to terms in the
  target language (given in \code{target}). A "foreign language" does not
  only have to be another language per se, but could also be a vocabulary
  with a different set of terms that carry the same semantic meaning as the
  target terms. If target does not exist, the terms are simply registered as
  "original" to be used for fuzzy matching.}
}
\examples{
library(readr)
inPath <- system.file("test_datasets", package = "arealDB", mustWork = TRUE)

# start the example database
makeExampleDB(until = "setPath")

# create index from an already existing table
comm <- read_csv(file = paste0(inPath, "/id_commodities.csv"),
                 col_types = "iccc")
setVariables(input = comm, variable = "commodities",
             pid = "faoID", target = "simpleName")
}
