% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/geography.R
\docType{methods}
\name{geography}
\alias{geography}
\alias{get_coordinates}
\alias{get_coordinates-method}
\alias{set_coordinates<-}
\alias{set_coordinates-method}
\alias{get_coordinates,Matrix-method}
\alias{set_coordinates<-,Matrix-method}
\alias{set_coordinates,Matrix-method}
\title{Spatial Information}
\usage{
get_coordinates(object)

set_coordinates(object) <- value

\S4method{get_coordinates}{Matrix}(object)

\S4method{set_coordinates}{Matrix}(object) <- value
}
\arguments{
\item{object}{An object from which to get or set element(s).}

\item{value}{A possible value for the element(s) of \code{object} (see
below).}
}
\description{
Deal with spatial information.
}
\details{
An attempt is made to interpret the argument \code{value} in a way suitable
 for geographic coordinates.

 If \code{value} is a:
 \describe{
  \item{\code{list}}{containing components "\code{x}", "\code{y}" and
  "\code{z}", these are used to define coordinates (longitude, latitude and
  elevation, respectively). If "\code{z}" is missing, the vertical
  coordinates will be ignored (and \code{NA} will be generated).}
  \item{\code{matrix} or \code{data.frame} with two or more columns}{the
  first is assumed to contain the \code{x} values, the second the \code{y}
  and the third the \code{z} values. \emph{Note} that if \code{value} has
  columns named "\code{x}", "\code{y}" and "\code{z}", these columns will be
  used. If \code{value} has only two columns or has columns named "\code{x}"
  and "\code{y}" but not "\code{z}", the vertical coordinates will be ignored
  (and \code{NA} will be generated).}
 }
}
\note{
EXPERIMENTAL: subject to major changes in a future release.
}
\examples{
## Create a count data matrix
A <- CountMatrix(data = sample(0:10, 100, TRUE), nrow = 10, ncol = 10,
                 dimnames = list(LETTERS[1:10], NULL))

## Set geographic coordinates as a matrix
B <- matrix(data = sample(0:10, 30, TRUE), nrow = 10, ncol = 3)
set_coordinates(A) <- B
get_coordinates(A)

## Set geographic coordinates as a data.frame
B <- data.frame(sample(0:10, 5, TRUE), sample(0:10, 5, TRUE), sample(0:10, 5, TRUE),
                row.names = LETTERS[seq(1, 10, 2)])
set_coordinates(A) <- B
get_coordinates(A)

## Set geographic coordinates as a list
B <- list(X = sample(0:10, 10, TRUE), Y = sample(0:10, 10, TRUE))
set_coordinates(A) <- B
get_coordinates(A)

## Unset geographic coordinates
set_coordinates(A) <- NULL
get_coordinates(A)
}
\author{
N. Frerebeau
}
\concept{geography}
