% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/statistics.R
\docType{methods}
\name{bootstrap}
\alias{bootstrap}
\alias{bootstrap-method}
\alias{bootstrap,numeric-method}
\title{Bootstrap Estimation}
\usage{
bootstrap(object, ...)

\S4method{bootstrap}{numeric}(object, do, n, ..., f = NULL)
}
\arguments{
\item{object}{A \code{\link{numeric}} vector.}

\item{...}{Extra arguments to be passed to \code{do}.}

\item{do}{A \code{\link{function}} that takes \code{object} as an argument and returns a
single numeric value.}

\item{n}{A non-negative \code{\link{integer}} giving the number of bootstrap
replications.}

\item{f}{A \code{\link{function}} that takes a single numeric vector (the result of
\code{do}) as argument.}
}
\value{
If \code{f} is \code{NULL} (the default), \code{bootstrap()} returns a named \code{numeric}
vector with the following elements:
\describe{
\item{\code{original}}{The observed value of \code{do} applied to \code{object}.}
\item{\code{mean}}{The bootstrap estimate of mean of \code{do}.}
\item{\code{bias}}{The bootstrap estimate of bias of \code{do}.}
\item{\code{error}}{he bootstrap estimate of standard error of \code{do}.}
}

If \code{f} is a \code{function}, \code{bootstrap()} returns the result of \code{f} applied to
the \code{n} values of \code{do}.
}
\description{
Samples randomly from the elements of \code{object} with replacement.
}
\examples{
x <- rnorm(20)

## Bootstrap
bootstrap(x, do = mean, n = 100)

## Estimate the 25th and 95th percentiles
quant <- function(x) { quantile(x, probs = c(0.25, 0.75)) }
bootstrap(x, n = 100, do = mean, f = quant)

## Get the n bootstrap values
bootstrap(x, n = 100, do = mean, f = function(x) { x })

## Jackknife
jackknife(x, do = mean) # Sample mean

## Get the leave-one-out values instead of summary
jackknife(x, do = mean, f = function(x) { x })
}
\seealso{
Other resampling methods: 
\code{\link{jackknife}()}
}
\author{
N. Frerebeau
}
\concept{resampling methods}
