% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/sparsity.R
\docType{methods}
\name{sparsity}
\alias{sparsity}
\alias{sparsity-method}
\alias{sparsity,matrix-method}
\alias{sparsity,data.frame-method}
\title{Sparsity}
\usage{
sparsity(x, ...)

\S4method{sparsity}{matrix}(x, count = FALSE)

\S4method{sparsity}{data.frame}(x, count = FALSE)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{count}{A \code{\link{logical}} scalar: should a count be returned instead of a
proportion?}
}
\value{
A length-one \code{\link{numeric}} vector.
}
\description{
Computes data sparsity (proportion of zeros).
}
\details{
If \code{x} is a \code{data.frame}, sparsity is computed on \code{numeric} variables only.
}
\examples{
## Create a data matrix
X <- matrix(sample(0:9, 15, TRUE), nrow = 3, ncol = 5)

## Add NA
k <- sample(1:15, 3, FALSE)
X[k] <- NA

## Sparsity
sparsity(X)

## Quick description
describe(X)
}
\seealso{
Other data summaries: 
\code{\link{describe}()}
}
\author{
N. Frerebeau
}
\concept{data summaries}
