% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/remove.R, R/replace.R
\docType{methods}
\name{empty}
\alias{empty}
\alias{remove_empty}
\alias{remove_empty-method}
\alias{replace_empty}
\alias{replace_empty-method}
\alias{remove_empty,ANY-method}
\alias{replace_empty,matrix-method}
\alias{replace_empty,data.frame-method}
\title{Tools for Working With Empty String}
\usage{
remove_empty(x, ...)

replace_empty(x, ...)

\S4method{remove_empty}{ANY}(x, margin = 1, all = FALSE, na.rm = FALSE)

\S4method{replace_empty}{matrix}(x, value)

\S4method{replace_empty}{data.frame}(x, value)
}
\arguments{
\item{x}{An \R object (should be a \code{\link{matrix}} or a \code{\link{data.frame}}).}

\item{...}{Currently not used.}

\item{margin}{A length-one \code{\link{numeric}} vector giving the subscripts which the
function will be applied over (\code{1} indicates rows, \code{2} indicates columns).}

\item{all}{A \code{\link{logical}} scalar. If \code{TRUE}, only the rows/columns whose
values all meet the condition defined by \code{f} are considered. If \code{FALSE}
(the default), only rows/columns where at least one value validates the
condition defined by \code{f} are considered.}

\item{na.rm}{A \code{\link{logical}} scalar: should \code{NA} values be stripped before the
computation proceeds?}

\item{value}{A possible replacement value.}
}
\description{
\itemize{
\item \code{remove_empty()} remove rows/columns that contain empty strings.
\item \code{replace_empty()} replaces empty strings.
}
}
\examples{
## Create a data matrix
X <- matrix(sample(LETTERS, 25, TRUE), nrow = 5, ncol = 5)

## Add empty string
k <- sample(1:25, 3, FALSE)
X[k] <- ""
X

## Remove rows with empty strings
remove_empty(X, margin = 1)

## Replace empty strings
replace_empty(X, value = "XXX")
}
\seealso{
Other data cleaning tools: 
\code{\link{compact}()},
\code{\link{count}()},
\code{\link{detect}()},
\code{\link{discard}()},
\code{\link{infinite}},
\code{\link{keep}()},
\code{\link{missing}},
\code{\link{remove_constant}()},
\code{\link{zero}}
}
\author{
N. Frerebeau
}
\concept{data cleaning tools}
