% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/assign.R
\docType{methods}
\name{assign}
\alias{assign}
\alias{assign_colnames}
\alias{assign_colnames-method}
\alias{assign_rownames}
\alias{assign_rownames-method}
\alias{assign_rownames,data.frame-method}
\alias{assign_colnames,data.frame-method}
\title{Assign a Specific Row/Column to the Column/Row Names}
\usage{
assign_colnames(x, ...)

assign_rownames(x, ...)

\S4method{assign_rownames}{data.frame}(x, column, remove = TRUE)

\S4method{assign_colnames}{data.frame}(x, row, remove = TRUE)
}
\arguments{
\item{x}{A \code{\link{data.frame}}.}

\item{...}{Currently not used.}

\item{column}{A length-one \code{\link{numeric}} vector specifying the column number
that is to become the row names.}

\item{remove}{A \code{\link{logical}} scalar: should the specified row/column be removed
after making it the column/row names?}

\item{row}{A length-one \code{\link{numeric}} vector specifying the row number that is
to become the column names.}
}
\value{
A \code{\link{data.frame}}.
}
\description{
Assign a Specific Row/Column to the Column/Row Names
}
\examples{
X <- data.frame(
  x = 1:5,
  y = 6:10,
  z = LETTERS[1:5]
)

## Assign column to row names
(Y <- assign_rownames(X, 3))

## Append row names to data.frame
(Z <- append_rownames(Y))
}
\seealso{
Other transformation tools: 
\code{\link{append}()}
}
\author{
N. Frerebeau
}
\concept{transformation tools}
