% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/X_decor.R
\name{X_decor}
\alias{X_decor}
\title{Decorrelation of a matrix X, given a response variable Y.}
\usage{
X_decor(X, Y, tree = NULL, nclust = 1, maxnbfactors = 10)
}
\arguments{
\item{X}{the matrix (or data.frame) of covariates, dimension n*p (n is the sample size, p the number of covariates). X must have colnames and rownames.}

\item{Y}{the vector of the response, length n.}

\item{tree}{the dendrogram of the covariates (object obtained before by the function clustering). By default, tree=NULL.}

\item{nclust}{integer, the number of clusters in the covariates (1  by default).}

\item{maxnbfactors}{integer, the maximum number of factors in the clusters. By default: maxnbfactors=10.}
}
\value{
a matrix X.decorrele, with the same dimension, same rownames and same colnames than X.
}
\description{
Decorrelation of a matrix X, given a response variable Y.
}
\details{
The function X_decor applies the factor analysis method FAMT in the different clusters of variables. The clusters must have been defined before (with the function "clustering").
}
\examples{
toys.data
X<-toys.data$x
Y<-toys.data$Y
Tree <- clustering(X,plot=FALSE)
nclust <- Tree[[2]]
tree <- Tree[[1]]
library(ClustOfVar)
library(FAMT)
X.deco<- X_decor(X, Y, tree, nclust, maxnbfactors=10)
}
