% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na.operations.R
\name{NA.operations}
\alias{NA.operations}
\alias{allNA}
\alias{includeNA}
\alias{includeNA.factor}
\alias{includeNA.character}
\alias{includeNA.numeric}
\title{Some functions to handle NAs}
\usage{
allNA(x)

includeNA(x, label, ...)

\method{includeNA}{factor}(x, label = "(Missing)", first = FALSE, ...)

\method{includeNA}{character}(x, label = "(Missing)", ...)

\method{includeNA}{numeric}(x, label, ...)
}
\arguments{
\item{x}{An object}

\item{label}{A character string denoting the label to set \code{NA}s to.}

\item{...}{Other arguments (not in use at this time).}

\item{first}{Logical; should the new label be the first level?}
}
\description{
\code{allNA} tests if all elements are NA, and \code{includeNA} sets the
  \code{NA}s in a character vector or factor to an explicit label.
}
\seealso{
\code{\link{is.na}}, \code{\link{anyNA}}
}
\author{
Ethan Heinzen
}
