% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RweaveAscii.r, R/weaverAscii.r
\name{RweaveT2t}
\alias{RweaveT2t}
\alias{RtangleT2t}
\alias{RweaveT2tOptions}
\alias{RweaveT2tFinish}
\alias{RweaveT2tWritedoc}
\alias{RweaveT2tSetup}
\alias{RweaveT2tRuncode}
\alias{weaverT2t}
\alias{weaverT2tSetup}
\title{A driver to parse txt2tags noweb files with Sweave tool
This driver parses txt2tags files containing R code and replace pieces of
code with their output.}
\usage{
RweaveT2t()

RweaveT2tSetup(
  file,
  syntax,
  output = NULL,
  quiet = FALSE,
  debug = FALSE,
  extension = "t2t",
  backend = "txt2tags",
  openSchunk = "```",
  closeSchunk = "\\n```\\n",
  openSinput = "",
  closeSinput = "",
  openSoutput = "\\n",
  closeSoutput = "",
  indent = "",
  openInclude = "\%!include: ",
  closeInclude = ".t2t",
  openFig = "[",
  closeFig = "]",
  ...
)

weaverT2tSetup(
  file,
  syntax,
  output = NULL,
  quiet = FALSE,
  debug = FALSE,
  extension = "t2t",
  backend = "txt2tags",
  openSchunk = "```",
  closeSchunk = "\\n```\\n",
  openSinput = "",
  closeSinput = "",
  openSoutput = "\\n",
  closeSoutput = "",
  indent = "",
  openInclude = "\%!include: ",
  closeInclude = ".t2t",
  openFig = "[",
  closeFig = "]",
  use.cache = TRUE,
  ...
)

weaverT2t()
}
\arguments{
\item{file}{file}

\item{syntax}{syntax}

\item{output}{output}

\item{quiet}{quite}

\item{debug}{debug}

\item{...}{...}

\item{use.cache}{use.cache}

\item{stylepath}{stylepath}
}
\value{
None value is returned. From a .Rnw noweb file, the corresponding
  .t2t is produced (as eventuals files for graphs).
}
\description{
A driver to parse txt2tags noweb files with Sweave tool
This driver parses txt2tags files containing R code and replace pieces of
code with their output.

RweaveT2tSetup

weaverT2tSetup

weaverT2t
}
\note{
In order to work properly, noweb codes have to be located at the
  beginning of a line (no indentation).

Compare with RweaveLatex driver, RweaveT2t provides one new option :
  \code{format} to choose the format of figure that will be inserted in the
  final document.

In addition, \code{cache} option from \code{weaver}
  package is also available with \code{weaverT2t} driver.

A wrapper for \code{Sweave} can be used, named \code{T2t}.
}
\examples{
  \dontrun{
T2t("file.Rnw")
  }

}
\seealso{
\code{\link[utils]{Sweave}}, \code{\link{T2t}}
}
\author{
David Hajage \email{dhajage@gmail.com}
}
\keyword{IO}
\keyword{file}
\keyword{internal}
