% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/embed.R
\name{asciicast_start_process}
\alias{asciicast_start_process}
\title{Start an asciicast background process}
\usage{
asciicast_start_process(
  startup = NULL,
  timeout = 10,
  record_env = NULL,
  interactive = TRUE,
  locales = get_locales(),
  options = NULL,
  show_output = FALSE
)
}
\arguments{
\item{startup}{Quoted language object to run in the subprocess before
starting the recording.}

\item{timeout}{Idle timeout, in seconds If the R subprocess running
the recording does not answer within this limit, it is killed and the
recording stops.}

\item{record_env}{Environment variables to set for the R subprocess.}

\item{interactive}{Whether to run R in interactive mode. Note that in
interactive mode R might ask for terminal input.}

\item{locales}{Locales to set in the asciicast subprocess. Defaults
to the current locales in the main R process. Specify a named character
vector here to override some of the defaults. See also \code{\link[=get_locales]{get_locales()}}.}

\item{options}{Options to set in the subprocess, a named list.
They are deparsed to code, and then the code setting them is
executed in the subprocess. See \code{\link[=asciicast_options]{asciicast_options()}} for the
defaults. Supply a named list here to override the defaults or set
additionsl ones. Passing large and/or complicated options here might
not work, or might be slow.}

\item{show_output}{Whether to show the output of the subprocess in
real time.}
}
\value{
The R process, a \link[processx:process]{processx::process} object.
}
\description{
This is for expert use, if you want to run multiple recordings in the
same process.
}
\examples{
\dontshow{if (!asciicast:::is_rcmd_check()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use the same R process to record multiple casts
process <- asciicast_start_process()
script1 <- "a <- runif(10)\n"
script2 <- "a\n"
cast1 <- record(textConnection(script1), process = process)
cast2 <- record(textConnection(script2), process = process)
cast1
cast2
\dontshow{\}) # examplesIf}
}
\seealso{
Other asciicast functions: 
\code{\link{asciicast-package}},
\code{\link{read_cast}()},
\code{\link{record}()},
\code{\link{write_json}()}
}
\concept{asciicast functions}
