% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assert-is-type-utils.R, R/is-type-utils.R
\name{assert_is_relistable}
\alias{assert_is_relistable}
\alias{is_relistable}
\title{Is the input relistable?}
\usage{
assert_is_relistable(x, severity = getOption("assertive.severity", "stop"))

is_relistable(x, .xname = get_name_in_parent(x))
}
\arguments{
\item{x}{Input to check.}

\item{severity}{How severe should the consequences of the assertion be?
Either \code{"stop"}, \code{"warning"}, \code{"message"}, or \code{"none"}.}

\item{.xname}{Not intended to be used directly.}
}
\value{
\code{is_relistable} wraps \code{is.relistable}, providing more 
information on failure. The \code{assert_*} functions return nothing but
throws an error if the corresponding \code{is_*} function returns 
\code{FALSE}.
}
\description{
Checks to see if the input is relistable.
}
\examples{
assert_is_relistable(as.relistable(list(1,2,3)))
#These examples should fail.
assertive.base::dont_stop(assert_is_relistable(list(1,2,3)))
}
\seealso{
\code{\link[utils]{is.relistable}} and \code{\link{is_scalar}}.
}

