% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assertions.R
\name{insist}
\alias{insist}
\alias{insist_}
\title{Raises error if dynamically created predicate is FALSE in any columns selected}
\usage{
insist(data, predicate_generator, ..., error_fun = assertr_stop)

insist_(data, predicate_generator, ..., .dots, error_fun = assertr_stop,
  .nameofpred = "")
}
\arguments{
\item{data}{A data frame}

\item{predicate_generator}{A function that is applied
to each of the column vectors selected. This will produce,
for every column, a true predicate function to be applied to
every element in the column vectors selected}

\item{...}{Comma separated list of unquoted expressions.
Uses dplyr's \code{select} to select
columns from data.}

\item{error_fun}{Function to call if assertion fails. Takes one error
string. Uses \code{stop} by default}

\item{.dots}{Use insist_() to select columns using standard evaluation.}

\item{.nameofpred}{Text representation of predicate for printing in case
        of assertion violation. Will automatically be retrieved if left
        blank (default)}
}
\value{
data if dynamically created predicate assertion is TRUE. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function applies a predicate
generating function to each of the columns indicated. It will then use these
predicates to check every element of those columns. If any of these
predicate applications yield FALSE, this function will raise an error,
effectively terminating the pipeline early. If there are no FALSES, this
function will just return the data that it was supplied for further use in
later parts of the pipeline.
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{
insist(iris, within_n_sds(3), Sepal.Length)   # returns iris

# equivalent using standard evaluation
insist_(iris, within_n_sds(3), "Sepal.Length")

library(magrittr)

iris \%>\%
  insist(within_n_sds(4), Sepal.Length:Petal.Width)
  # anything here will run

\dontrun{
iris \%>\%
  insist(within_n_sds(3), Sepal.Length:Petal.Width)
  # datum at index 16 of 'Sepal.Width' vector is (4.4)
  # is outside 3 standard deviations from the mean of Sepal.Width.
  # The check fails, raises a fatal error, and the pipeline
  # is terminated so nothing after this statement will run}
}
\seealso{
\code{\link{assert}} \code{\link{verify}} \code{\link{insist_rows}}
         \code{\link{assert_rows}}
}

