% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assertions.R
\name{verify}
\alias{verify}
\title{Raises error if expression is FALSE anywhere}
\usage{
verify(data, expr, error_fun = stop)
}
\arguments{
\item{data}{A data frame, list, or environment}

\item{expr}{A logical expression}

\item{error_fun}{Function to call if assertion fails. Takes one error
        string. Uses \code{stop} by default}
}
\value{
data if verification passes. error if not.
}
\description{
Meant for use in a data analysis pipeline, this function will
just return the data it's supplied if all the logicals in the
expression supplied are TRUE. If at least one is FALSE, this
function will raise a error, effectively terminating the pipeline
early
}
\note{
See \code{vignette("assertr")} for how to use this in context
}
\examples{
verify(mtcars, drat > 2)     # returns mtcars
\dontrun{
verify(mtcars, drat > 3)     # produces error}


library(magrittr)            # for piping operator

\dontrun{
mtcars \%>\%
  verify(drat > 3) \%>\%
  # anything here will not run}

mtcars \%>\%
  verify(nrow(mtcars) > 2)
  # anything here will run

alist <- list(a=c(1,2,3), b=c(4,5,6))
verify(alist, length(a) > 2)
verify(alist, length(a) > 2 && length(b) > 2)
verify(alist, a > 0 & b > 2)

\dontrun{
alist \%>\%
  verify(alist, length(a) > 5)
  # nothing here will run}
}
\seealso{
\code{\link{assert}} \code{\link{insist}}
}

