% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/atable_longitudinal.R
\name{atable_longitudinal}
\alias{atable_longitudinal}
\alias{atable_longitudinal.data.frame}
\title{A longitudinal version of atable}
\usage{
atable_longitudinal(x, ...)

\method{atable_longitudinal}{data.frame}(
  x,
  target_cols,
  split_cols,
  group_col = NULL,
  format_numeric = atable_options("format_statistics_longitudinal.statistics_numeric"),
  format_factor = atable_options("format_statistics_longitudinal.statistics_factor"),
  ...
)
}
\arguments{
\item{x}{object passed to atable. Currently x must be a data.frame.}

\item{...}{Passed to \code{\link{atable}}.}

\item{target_cols}{character. Exactly one of colnames(x).}

\item{split_cols}{character. Exactly one of colnames(x).}

\item{group_col}{character or NULL. If character then, one of colnames(x).}

\item{format_numeric}{a function that defines the format of numeric variables.
Analog to format_factor.}

\item{format_factor}{a function that defines the format of factor variables.
Default is defined in \code{\link{atable_options}}. See \code{\link{check_format_statistics}} for the return-value of this function.}
}
\value{
data.frame
}
\description{
This is a wrapper for atable(), calculating the same statistics, but with different format.
}
\details{
The intention is to report longitudinal data, i.e. data measured on the same objects on multiple times points.

This function allows only one target_col and only one split_col (the time point of the measurement).

The longitudinal formatting is:

The names of the target_col and split_col do not show up in the table. The names should thus be written in the caption of the table.


Numeric target_cols get one line in the table; the format of the statistics is: mean (sd), N, missing.

Factor target_cols also get one line in the table, when it has only two levels and only the first level
is displayed in the table and the name of the variable is omitted. This is intended for item like "Sex at birth: Female/Male".
Knowing the percentage of Female is sufficient in this case (when NAs are not counted).
The name of the target_cols and its first level should be stated in the caption of the table, otherwise the table is uninformative.
The format of the statistics is: percent % (n/total).

Factors with three or more levels get one line per level and the name of the variable is omitted.
The format of the statistics is: percent % (n). The total number of obsercations is shown in an extra row.

Argument block must omitted, as there is only one target_col and nothing to block.

See examples.
}
\section{Methods (by class)}{
\itemize{
\item \code{data.frame}: a longitudinal version of atable.
}}

\examples{
# create data with a time-variable
x = atable::test_data
set.seed(42)
x = within(x, {time = sample(paste0("time_", 1:5), size=nrow(x), replace = TRUE)})
split_cols = "time"
group_col = "Group2"

# table for a factor with two levels
atable_longitudinal(x,
  target_cols = "Split2",
  group_col = group_col,
  split_cols = split_cols,
  add_margins = TRUE)


# table for a factor with three levels
atable_longitudinal(x,
  target_cols = "Split1",
  group_col = group_col,
  split_cols = split_cols,
  add_margins = TRUE)


# table for a numeric variable
atable_longitudinal(x,
  target_cols = "Numeric",
  group_col = group_col,
  split_cols = split_cols,
  add_margins = TRUE)

# To print the table in Word or with Latex, use
# e.g. \link[Hmisc]{latex} or \link[officer]{body_add_table}.
# No further modification of the table is needed.
# See \code{\link{atable_compact}} for examples.


}
