% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load-rec.R
\name{load_rec}
\alias{load_rec}
\title{Load information for SSB and Recruits from an Atlantis model run.}
\usage{
load_rec(yoy, ssb, prm_biol)
}
\arguments{
\item{yoy}{Character string giving the connection of the YOY file.
The filename usually contains \code{outputYOY} and ends in \code{.txt}".}

\item{ssb}{Character string giving the connection of the YOY file.
The filename usually contains \code{outputSSB} and ends in \code{.txt}".}

\item{prm_biol}{Character string giving the connection to the biological parameterfile.
The filename usually contains \code{biol_fishing} and does end in \code{.prm}.}
}
\value{
Dataframe with information about ssb in tonnes and recruits in
thousands.
}
\description{
Load information for SSB and Recruits from an Atlantis model run.
}
\examples{
d <- system.file("extdata", "setas-model-new-trunk", package = "atlantistools")
yoy <- file.path(d, "outputSETASYOY.txt")
ssb <- file.path(d, "outputSETASSSB.txt")
prm_biol <- file.path(d, "VMPA_setas_biol_fishing_Trunk.prm")

load_rec(yoy, ssb, prm_biol)
}
\seealso{
Other load functions: \code{\link{load_box}},
  \code{\link{load_bps}}, \code{\link{load_dietcheck}},
  \code{\link{load_fgs}}, \code{\link{load_init_age}},
  \code{\link{load_init}}, \code{\link{load_nc_physics}},
  \code{\link{load_nc}}, \code{\link{load_spec_mort}},
  \code{\link{load_txt}}
}
