% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SwordClient.R
\docType{class}
\name{SwordClient}
\alias{SwordClient}
\title{SwordClient class}
\format{
\code{\link{R6Class}} object.
}
\value{
Object of \code{\link{R6Class}} for modelling an Sword client
}
\description{
This class models an Sword service client
}
\details{
SwordClient
}
\note{
Abstract class
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{API}
\keyword{Client}
\keyword{SWORD}
\section{Super classes}{
\code{\link[atom4R:atom4RLogger]{atom4R::atom4RLogger}} -> \code{\link[atom4R:AtomPubClient]{atom4R::AtomPubClient}} -> \code{SwordClient}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SwordClient-new}{\code{SwordClient$new()}}
\item \href{#method-SwordClient-getServiceDocument}{\code{SwordClient$getServiceDocument()}}
\item \href{#method-SwordClient-getCollectionMembers}{\code{SwordClient$getCollectionMembers()}}
\item \href{#method-SwordClient-clone}{\code{SwordClient$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="ERROR"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-ERROR'><code>atom4R::atom4RLogger$ERROR()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="INFO"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-INFO'><code>atom4R::atom4RLogger$INFO()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="WARN"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-WARN'><code>atom4R::atom4RLogger$WARN()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="getClass"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-getClass'><code>atom4R::atom4RLogger$getClass()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="getClassName"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-getClassName'><code>atom4R::atom4RLogger$getClassName()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="atom4RLogger" data-id="logger"><a href='../../atom4R/html/atom4RLogger.html#method-atom4RLogger-logger'><code>atom4R::atom4RLogger$logger()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="getPwd"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-getPwd'><code>atom4R::AtomPubClient$getPwd()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="getToken"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-getToken'><code>atom4R::AtomPubClient$getToken()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="getUser"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-getUser'><code>atom4R::AtomPubClient$getUser()</code></a></li>
<li><span class="pkg-link" data-pkg="atom4R" data-topic="AtomPubClient" data-id="listCollections"><a href='../../atom4R/html/AtomPubClient.html#method-AtomPubClient-listCollections'><code>atom4R::AtomPubClient$listCollections()</code></a></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordClient-new"></a>}}
\if{latex}{\out{\hypertarget{method-SwordClient-new}{}}}
\subsection{Method \code{new()}}{
This method is to instantiate an Sword Client. By default the version is set to "2".

   The \code{keyring_backend} can be set to use a different backend for storing
   the SWORD API user token with \pkg{keyring} (Default value is 'env').

   The \code{logger} allows to specify the level of log (default is NULL), either "INFO"
   for \pkg{atom4R} logs or "DEBUG" for verbose HTTP client (curl) logs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordClient$new(
  url,
  version = "2",
  user = NULL,
  pwd = NULL,
  token = NULL,
  logger = NULL,
  keyring_backend = "env"
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{url}

\item{\code{version}}{version. Default is "2"}

\item{\code{user}}{user}

\item{\code{pwd}}{pwd}

\item{\code{token}}{token}

\item{\code{logger}}{logger}

\item{\code{keyring_backend}}{keyring backend. Default is 'env'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordClient-getServiceDocument"></a>}}
\if{latex}{\out{\hypertarget{method-SwordClient-getServiceDocument}{}}}
\subsection{Method \code{getServiceDocument()}}{
Get service document
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordClient$getServiceDocument(force = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{force}}{force Force getting/refreshing of service document}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
object of class \link{SwordServiceDocument}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordClient-getCollectionMembers"></a>}}
\if{latex}{\out{\hypertarget{method-SwordClient-getCollectionMembers}{}}}
\subsection{Method \code{getCollectionMembers()}}{
Get collection members. Unimplemented abstract method at \link{SwordClient} level
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordClient$getCollectionMembers()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SwordClient-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SwordClient-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SwordClient$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
