# WARNING - Generated by {fusen} from dev/flat_create_dependencies_file.Rmd: do not edit by hand

#' Create the list of instructions to install dependencies from a DESCRIPTION file
#' 
#' Outputs the list of instructions and a "dependencies.R" file with instructions in the "inst/" directory
#'
#' @param path path to the DESCRIPTION file
#' @param field DESCRIPTION field to parse, "Import" and "Depends" by default. Can add "Suggests"
#' @param to path where to save the dependencies file. Set to "inst/dependencies.R" by default. Set to `NULL` if you do not want the file, but only the instructions as a list of character.
#' @param open_file Logical. Open the file created in an editor
#' @param ignore_base Logical. Whether to ignore package coming with base, as they cannot be installed (default TRUE)
#' @param install_only_if_missing Logical Modify the installation instructions to check, beforehand, if the packages are missing . (default FALSE)
#' @export
#' @return List of R instructions to install all dependencies from a DESCRIPTION file. Side effect: creates a R file containing these instructions.
#' @importFrom glue glue glue_collapse
#' @importFrom desc description
#' @importFrom utils packageDescription
#'
#' @examples
#' # Create a fake package
#' tmpdir <- tempfile(pattern = "depsfile")
#' dir.create(tmpdir)
#' file.copy(system.file("dummypackage",package = "attachment"), tmpdir,
#'           recursive = TRUE)
#' dummypackage <- file.path(tmpdir, "dummypackage")
#'
#' # Create the dependencies commands but no file
#' create_dependencies_file(
#'   path = file.path(dummypackage,"DESCRIPTION"),
#'   to = NULL,
#'   open_file = FALSE)
#'
#' # Create the dependencies files in the package
#' create_dependencies_file(
#'   path = file.path(dummypackage,"DESCRIPTION"),
#'   to = file.path(dummypackage, "inst/dependencies.R"),
#'   open_file = FALSE)
#' list.files(file.path(dummypackage, "inst"))
#' # browseURL(dummypackage)
#'
#' # Clean temp files after this example
#' unlink(tmpdir, recursive = TRUE)
create_dependencies_file <- function(path = "DESCRIPTION",
                                     field = c("Depends", "Imports"),
                                     to = "inst/dependencies.R", 
                                     open_file = TRUE,
                                     ignore_base = TRUE,
                                     install_only_if_missing = FALSE) {

  # get all packages
  ll <- att_from_description(path = path, field = field)
  # get pkg in remotes
  if (isTRUE(ignore_base)) {
    to_remove <-
      which(lapply(ll , packageDescription, field = "Priority") == "base")
    if (length(to_remove) > 0) {
      ll <- ll[-to_remove]
    }

  }

  desc <- description$new(path)
  # Get previous dependencies in Description in case version is set
  remotes_orig <- desc$get_remotes()

  content <- dependencies_file_text(ll = ll,
                         remotes_orig = remotes_orig,
                         install_only_if_missing = install_only_if_missing)

  if (!is.null(to)) {
    if (!dir.exists(dirname(to))) {
      dir.create(dirname(to), recursive = TRUE, showWarnings = FALSE)
      dir_to <- normalizePath(dirname(to))
    } else {
      dir_to <- normalizePath(dirname(to))
    }
    
    the_file <- file.path(dir_to, basename(to))
    # file.create(the_file)
    cat(unlist(content), sep  = "\n", file = the_file)

    if (interactive() && open_file) {
      utils::file.edit(file, editor = "internal")
    }
    
    return(invisible(content))
  } else {
    return(content)
  }
  

}

