% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RowMax.R
\name{RowMax}
\alias{RowMax}
\title{Maximum of Matrix Rows}
\usage{
RowMax(x)
}
\arguments{
\item{x}{input value (numeric)}
}
\value{
output value (numeric)
}
\description{
Maximum of Matrix Rows
}
\examples{
# generate a matrix of integers (also works for floats)
set.seed(0)
M = matrix(floor(runif(9, min=0, max=3)),
           nrow=3,
           ncol=3)
print(M)

# this outputs
#      [,1] [,2] [,3]
# [1,]    2    1    2
# [2,]    0    2    2
# [3,]    1    0    1

# apply RowMax() to the matrix M, reformat output as matrix again
# to keep the maxs on their corresponding rows
RowMax(M)

# this outputs
#      [,1]
# [1,]    2
# [2,]    2
# [3,]    1

}
