% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auk-country.r
\name{auk_country}
\alias{auk_country}
\title{Filter the EBD by country}
\usage{
auk_country(x, country, replace)
}
\arguments{
\item{x}{\code{auk_ebd} object; reference to EBD file created by \code{\link[=auk_ebd]{auk_ebd()}}.}

\item{country}{character; countries to filter by. Countries can either be
expressed as English names or
\href{https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2}{ISO 2-letter country codes}.
English names are matched via regular expressions using
\link[=countrycode]{countrycode}, so there is some flexibility in names.}

\item{replace}{logical; multiple calls to \code{auk_country()} are additive,
unless \code{replace = FALSE}, in which case the previous list of countries to
filter by will be removed and replaced by that in the current call.}
}
\value{
An \code{auk_ebd} object.
}
\description{
Define a filter for the eBird Basic Dataset (EBD) based on a set of
countries. This function only defines the filter and, once all filters have
been defined, \code{\link[=auk_filter]{auk_filter()}} should be used to call AWK and perform the
filtering.
}
\examples{
# country names and ISO2 codes can be mixed
# not case sensitive
country <- c("CA", "United States", "mexico")
system.file("extdata/ebd-sample.txt", package = "auk") \%>\%
  auk_ebd() \%>\%
  auk_country(country)
}
