% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{ebma_folding}
\alias{ebma_folding}
\title{Generates data fold to be used for EBMA tuning}
\usage{
ebma_folding(data, L2.unit, ebma.size)
}
\arguments{
\item{data}{The full survey data. A tibble.}

\item{L2.unit}{Geographic unit. A character scalar containing the column name
of the geographic unit in \code{survey} and \code{census} at which outcomes
should be aggregated.}

\item{ebma.size}{EBMA fold size. A number in the open unit interval
indicating the proportion of respondents to be allocated to the EBMA fold.
Default is \eqn{1/3}.}
}
\value{
Returns a list with two elements which are both tibble. List element
  one is named \code{ebma_fold} and contains the tibble used in Ensemble
  Bayesian Model Averaging Tuning. List element two is named \code{cv_data}
  and contains the tibble used for classifier tuning.
}
\description{
#' \code{ebma_folding()} generates a data fold that will not be used in
classifier tuning. It is data that is needed to determine the optimal
tolerance for EBMA.
}
