% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise_search.R
\name{stepwise_search}
\alias{stepwise_search}
\alias{backward_search}
\alias{summary.search}
\alias{print.search}
\alias{plot_search}
\title{Stepwise Selection Search}
\usage{
stepwise_search(
  X,
  criterion = c("ipoqll", "ipoqlldif"),
  incl_set = c(),
  groups_map = c(),
  cores = NULL,
  optim_control_iq = c(),
  optim_control_oq = c(),
  isTracked = TRUE,
  isContinued = FALSE,
  prevData = c(),
  fileOutput = FALSE,
  tempFile = "temp_stepSearch.RData",
  isConvert = FALSE,
  setting_par_iq = c(),
  setting_par_oq = c(),
  method = c("fast", "novel")
)

backward_search(
  X,
  criterion = c("ipoqll", "ipoqlldif"),
  incl_set = c(),
  groups_map = c(),
  cores = NULL,
  optim_control_iq = c(),
  optim_control_oq = c(),
  isTracked = TRUE,
  isContinued = FALSE,
  prevData = c(),
  fileOutput = FALSE,
  tempFile = "temp_backSearch.RData",
  isConvert = FALSE,
  setting_par_iq = c(),
  setting_par_oq = c(),
  method = c("fast", "novel")
)

\method{summary}{search}(object, ...)

\method{print}{search}(x, ...)

plot_search(obj, remOrdered = TRUE, locateMax = TRUE, ...)
}
\arguments{
\item{X}{A matrix or data.frame of the observed responses (ordinal or binary response).}

\item{criterion}{The criterion that should be used. The default is ipoqll.}

\item{incl_set}{A vector of initial items in the included set to start the search. The default is to start with full items.}

\item{groups_map}{A matrix or vector to map the subject to the DIFs groups.}

\item{cores}{An integer value of number of cores should be used for computation. The default is 2.}

\item{optim_control_iq}{The optimisation setting of the included set. See \code{\link[stats:optim]{stats::optim()}} \code{control} parameter.}

\item{optim_control_oq}{The optimisation setting of the excluded set. See \code{\link[stats:optim]{stats::optim()}} \code{control} parameter.}

\item{isTracked}{A logical value whether the progress need to be tracked or not.}

\item{isContinued}{A logical value whether this search is continuing another unfinished search.}

\item{prevData}{The filename of the temporary .RData file of the unfinished search.}

\item{fileOutput}{The filename if it is wished to save the output results in file (.RData and .csv) and FALSE if not.}

\item{tempFile}{The filename of the temporary file to track the search progress. The default is \code{"temp_stepSearch.RData"} which also automatically produces \code{"temp_stepSearch.csv"}.}

\item{isConvert}{A logical value whether it is wanted to recompute the score of the search results using IPOQ-LL-DIF criterion.}

\item{setting_par_iq}{a list of the optimization control setting parameters for the included set. See \code{setting} parameter in \code{\link[autoRasch:autoRaschOptions]{autoRaschOptions()}}.}

\item{setting_par_oq}{a list of the optimization control setting parameters for the included set. See \code{setting} parameter in \code{\link[autoRasch:autoRaschOptions]{autoRaschOptions()}}.}

\item{method}{The implementation option of log likelihood function. \code{fast} using a \code{c++} implementation and \code{novel} using an \code{R} implementation.}

\item{object}{The object of class \code{'search'}.}

\item{...}{Further arguments to be passed.}

\item{x}{The object of class \code{'search'}.}

\item{obj}{An object of class "search".}

\item{remOrdered}{A logical statement whether show the order of the items removal or not.}

\item{locateMax}{A logical statement whether the location of the maximum score is needed to be marked or not.}
}
\value{
Matrix of the highest scores (IQ-LL, OQ-LL, and IPOQ-LL) for every number of items in the included set in the set along with the corresponding itemset.
}
\description{
To search itemset that give maximum value of the criterion
}
\details{
To search the itemset that give the maximum score.
}
\examples{
\dontrun{
search_res <- backward_search(shortDIF,criterion = "ipoqll", incl_set = c(1:4), cores = 2)
plot_search(search_res, type="l")
}

}
