% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OEplot.R
\name{OEplot}
\alias{OEplot}
\title{Draw an Observed vs Expected plot}
\usage{
OEplot(fit, xnames = NULL, no = 3, maxy.lev = 5, median = TRUE)
}
\arguments{
\item{fit}{An object of class "coxph"}

\item{xnames}{Character Names of explanatory variable to plot}

\item{no}{integer Number of groups to be made}

\item{maxy.lev}{Integer Maximum unique length of a numeric variable to be treated as categorical variables}

\item{median}{logical}
}
\value{
No return value, called for side effects
}
\description{
Draw an Observed vs Expected plot
}
\examples{
library(survival)
data(cancer,package="survival")
fit=coxph(Surv(time,status)~rx+age+sex,data=colon)
OEplot(fit)
OEplot(fit,xnames="sex")
\dontrun{
fit=coxph(Surv(time,status)~age,data=colon)
OEplot(fit)
fit=coxph(Surv(time,status)~logWBC,data=anderson)
OEplot(fit)
}
}
