% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_scorecard.R
\name{auto_scorecard}
\alias{auto_scorecard}
\title{Functions to Automatically Generate Scorecards}
\usage{
auto_scorecard(
  feature = accepts,
  key_var = "application_id",
  y_var = "bad_ind",
  sample_rate = 0.7,
  points0 = 600,
  odds0 = 1/20,
  pdo = 50,
  max_depth = 3,
  tree_p = 0.1,
  missing_rate = 0,
  single_var_rate = 1,
  iv_set = 0.02,
  char_to_number = TRUE,
  na.omit = TRUE
)
}
\arguments{
\item{feature}{A data.frame with independent variables and target variable.}

\item{key_var}{A name of index variable name.}

\item{y_var}{A name of target variable.}

\item{sample_rate}{Training set sampling percentage.}

\item{points0}{Base point.}

\item{odds0}{odds.}

\item{pdo}{Point-to Double Odds.}

\item{max_depth}{Set the maximum depth of any node of the final tree, with the root node counted as depth 0. Values greater than 30 rpart will give nonsense results on 32-bit machines.}

\item{tree_p}{Meet the following conversion formula: minbucket = round(  p*nrow( df )).Smallest bucket(rpart):Minimum number of observations in any terminal <leaf> node.}

\item{missing_rate}{Data missing rate, variables smaller than this setting will be deleted.}

\item{single_var_rate}{The maximum proportion of a single variable, the variable greater than the setting will be deleted.}

\item{iv_set}{IV value minimum threshold, variable IV value less than the setting will be deleted.}

\item{char_to_number}{Whether to convert character variables to numeric.}

\item{na.omit}{na.omit returns the object with incomplete cases removed.}
}
\value{
A list containing data, bins, scorecards and models.
}
\description{
Functions to Automatically Generate Scorecards
}
\examples{
accepts <- read.csv(system.file("extdata", "accepts.csv", package = "autoScorecard" ))
auto_scorecard1 <- auto_scorecard( feature = accepts[1:2000,], key_var= "application_id",
y_var = "bad_ind",sample_rate = 0.7, points0 = 600, odds0=1/20, pdo = 50, max_depth = 3,
tree_p = 0.1, missing_rate = 0, single_var_rate = 1, iv_set = 0.02,
char_to_number = TRUE , na.omit = TRUE)
}
