% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binning_kmean.R
\name{binning_kmean}
\alias{binning_kmean}
\title{The K-means Binning
The k-means binning method first gives the center number, classifies the observation points using the Euclidean distance calculation and the distance from the center point,
and then recalculates the center point until the center point no longer changes, and uses the classification result as the binning of the result.}
\usage{
binning_kmean(df, feat, label, nbins = 3)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{feat}{A name of index variable name.}

\item{label}{A name of target variable.}

\item{nbins}{Number of bins,default:3.}
}
\value{
A data frame, including the contents of the bin, the upper bound of the bin, the lower bound of the bin, and all the contents returned by the get_IV function.
}
\description{
The K-means Binning
The k-means binning method first gives the center number, classifies the observation points using the Euclidean distance calculation and the distance from the center point,
and then recalculates the center point until the center point no longer changes, and uses the classification result as the binning of the result.
}
\examples{
accepts <- read.csv( system.file( "extdata" , "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
ddd <- binning_kmean( df = feature, feat= 'loan_term', label = 'bad_ind', nbins = 3)
}
