% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bins_unsupervised.R
\name{bins_unsupervised}
\alias{bins_unsupervised}
\title{Unsupervised Automatic Binning Function
By setting bin_nums, perform three unsupervised automatic binning}
\usage{
bins_unsupervised(
  df,
  id,
  label,
  methods = c("k_means", "equal_width", "equal_freq"),
  bin_nums
)
}
\arguments{
\item{df}{A data.frame with independent variables and target variable.}

\item{id}{A name of index.}

\item{label}{A name of target variable.}

\item{methods}{Simultaneously calculate three kinds of unsupervised binning("k_means","equal_width","equal_freq" ), the parameters only determine the final output result.}

\item{bin_nums}{Number of bins.}
}
\value{
A data frame, including the contents of the bin, the upper bound of the bin, the lower bound of the bin, and all the contents returned by the get_IV function.
}
\description{
Unsupervised Automatic Binning Function
By setting bin_nums, perform three unsupervised automatic binning
}
\examples{
accepts <- read.csv( system.file( "extdata" , "accepts.csv" , package = "autoScorecard" ))
feature <- stats::na.omit( accepts[,c(1,3,7:23)] )
f_1 <-bins_unsupervised(  df = feature , id="application_id" , label="bad_ind" ,
methods = c("k_means", "equal_width","equal_freq"  )  ,  bin_nums=10  )
}
