% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_palettes.R
\name{match_color}
\alias{match_color}
\title{Matching colors across palettes}
\usage{
match_color(colors, pal)
}
\arguments{
\item{colors}{One or more hexcodes to match with colors from the palette.}

\item{pal}{Optionally, a vector of hexcodes representing a palette in which
to find matches.
By default, the current theme's qualitative palette is used.}
}
\value{
A vector of hexcodes the length of the first argument.
}
\description{
Sometimes particular colours are coded in certain ways to facilitate
interpretation.
For example, perhaps primary colours or traffic light colours are used
to represent some discrete options.
Yet institutional palettes vary in terms of which colours they have
available.
This function uses the Euclidean distance of colours in CIELAB space to
those of a target palette to find the closes corresponding colours.
}
\examples{
match_color("#4575b4")
}
