% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lum_local_match.R
\name{lum_local_match}
\alias{lum_local_match}
\title{Match Filenames from LumiNUS.}
\usage{
lum_local_match(audit_file_path, local_files_dir, skip_name)
}
\arguments{
\item{audit_file_path}{The audit file downloaded from LumiNUS. This must
be an Excel file. It comes from the "Download Activity" button for the
corresponding folder. It should contain columns such as "Action Time",
"Action", etc. In the folder settings, students should be identified by
their NAME.}

\item{local_files_dir}{The directory containing the files downloaded from
LumiNUS. It is usually downloaded as a zip-file and then extracted.}

\item{skip_name}{The username to skip. Usually this is the instructor's name. This 
must be present.}
}
\value{
It returns a tibble, containing the remote and local filenames, matched
to the userid of students. The columns in this tibble are
\enumerate{
\item mod_time: file modification time, from the downloaded file.
\item luminus_time: time that the file was uploaded to LumiNUS; retrieved
from audit trail.
\item local_fname: The downloaded local file name.
\item luminus_fname: The filename that we see on LumiNUS.
}
}
\description{
A utility function for resolving duplicate filenames on
LumiNUS. (Only useful for NUS instructors!)
}
\details{
Here is how LumiNUS works to resolve duplicate filenames: It
will append the students' filenames to the end of the file (in parenthesis),
but it will only use the first 15 characters of the students' name. In
LumiNUS, filenames are not case-sensitive - test.Rmd and test.rmd are
considered duplicate filenames.

Here is how the function works: From the audit trail, it retrieves the name
of the most recent upload for each student. After converting these to
lowercase, duplicate file names have their student names appended. These
new names are matched to the filenames that were downloaded.

Remember to clean up the filenames after this, because knitr does not
like parentheses in file names!
}
\seealso{
\code{\link{replace_sp_chars_filename}}
}
