% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spec.R
\name{read_spec}
\alias{read_spec}
\title{Read yaml spec file}
\usage{
read_spec(spec_file = "spec.yml", metadata = NULL)
}
\arguments{
\item{spec_file}{`character`. Path to a yaml spec file}

\item{metadata}{Metadata of study}
}
\value{
An object of class `spec` which is a `list` where each element corresponds
to one output, e.g. `t_dm_IT`.
}
\description{
Read yaml spec file and split according to filter lists
}
\examples{
spec_file <- system.file("spec.yml", package = "autoslider.core")

## Take a look at the 'raw' content of the spec file
cat(readLines(spec_file)[1:24], sep = "\n")

## This is how it looks once read into R
spec <- read_spec(spec_file)
spec[1:3]

}
\author{
- Liming Li (`Lil128`)
- Thomas Neitmann (`neitmant`)
- Joe Zhu
}
