% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stack_thresh.R
\name{mean_stack_thresh}
\alias{mean_stack_thresh}
\title{Threshold every image frame in an image stack based on their mean.}
\usage{
mean_stack_thresh(img, method, fail = NA, ignore_black = FALSE,
  ignore_white = FALSE, ignore_na = FALSE)
}
\arguments{
\item{img}{A 4-dimensional array in the style of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, channel, frame]})
or a 3-dimensional array which is a single channel of an
\link[ijtiff:ijtiff_img]{ijtiff_img} (indexed by \code{img[y, x, frame]}).}

\item{method}{The name of the thresholding method you wish to use. The
available methods are \code{"IJDefault"}, \code{"Huang"}, \code{"Huang2"}, \code{"Intermodes"},
\code{"IsoData"}, \code{"Li"}, \code{"MaxEntropy"}, \code{"Mean"}, \code{"MinErrorI"}, \code{"Minimum"},
\code{"Moments"}, \code{"Otsu"}, \code{"Percentile"}, \code{"RenyiEntropy"}, \code{"Shanbhag"},
\code{"Triangle"} and \code{"Yen"}. Partial matching is performed i.e. \code{method = "h"}
is enough to get you \code{"Huang"} and \code{method = "in"} is enough to get you
\code{"Intermodes"}. To perform \emph{manual} thresholding (where you set the
threshold yourself), supply the threshold here as a number e.g. \code{method = 3.8} (so note that this would \emph{not} select the third method in the
above list of methods). This manual threshold will then be used to
threshold the sum stack to create a 2D mask and then this mask will be
applied to all frames in the stack. If you want a different method for each
channel, specify this parameter as a vector or list, one element per
channel.}

\item{fail}{When using \code{auto_thresh_apply_mask()}, to what value do you wish
to set the pixels which fail to exceed the threshold? \code{fail = 'saturate'}
sets them to saturated value (see 'Details'). \code{fail = 'zero'} sets them to
zero. You can also specify directly here a natural number (must be between
\code{0} and \code{2^16 - 1}) to use.}

\item{ignore_black}{Ignore black pixels/elements (zeros) when performing the
thresholding?}

\item{ignore_white}{Ignore white pixels when performing the thresholding? If
set to \code{TRUE}, the function makes a good guess as to what the white
(saturated) value would be (see 'Details'). If this is set to a number, all
pixels with value greater than or equal to that number are ignored.}

\item{ignore_na}{This should be \code{TRUE} if \code{NA}s in \code{int_arr} should be
ignored or \code{FALSE} if you want the presence of \code{NA}s in \code{int_arr} to throw
an error.}
}
\value{
An object of class \link{stack_threshed_img} which is the thresholded
image (an array in the style of an \link[ijtiff:ijtiff_img]{ijtiff_img}).
Pillars not exceeding the threshold are set to the \code{fail} value (default
\code{NA}).
}
\description{
An \link[ijtiff:ijtiff_img]{ijtiff_img} is a 4-dimensional array indexed by
\code{img[y, x, channel, frame]}. For each channel (which consists of a stack of
frames), this function finds a threshold based on the sum all of the frames,
uses this to create a mask and then applies this mask to every frame in the
stack (so for a given pillar in the image stack, either all the pixels
therein are thresholded away or all are untouched, where pillar \code{x,y} of
channel \code{ch} is \code{img[y, x, ch, ]}).
}
\details{
It's called \code{mean_stack_thresh()} and not \code{sum_stack_thresh()} because its
easier for people to visualize the mean of an image series than to visualize
the sum, but for the sake of this procedure, both are equivalent, except for
the fact that the thresholding routine invoked inside this function prefers
integers, which we get by using a sum but not by using a mean.

\itemize{\item Values greater than or equal to the found threshold
\emph{pass} the thresholding and values less than the threshold \emph{fail}
the thresholding.

\item{For \code{ignore_white = TRUE}, if the maximum value in the array is one of
\code{2^8-1}, \code{2^16-1} or \code{2^32-1}, then those max values are ignored.
That's because they're the white values in 8, 16 and 32-bit images
respectively (and these are the common image bit sizes to work with). This
guesswork has to be done because \code{R} does not know how many bits the image
was on disk. This guess is very unlikely to be wrong, and if it is, the
consequences are negligible anyway. If you're very concerned, then just
specify the white value as an integer in this \code{ignore_white} argument.}

\item{If you have set \code{ignore_black = TRUE} and/or \code{ignore_white = TRUE} but
you are still getting error/warning messages telling you to try them, then
your chosen method is not working for the given array, so you should try a
different method.}

\item For a given array, if all values are less than \code{2^8}, saturated value
is \code{2^8 - 1}, otherwise, saturated value is \code{2^16 - 1}. }
}
\examples{
img <- ijtiff::read_tif(system.file('extdata', '50.tif',
                                    package = 'autothresholdr'))
ijtiff::display(img[, , 1, 1])
img_thresh_mask <- mean_stack_thresh(img, 'Otsu')
ijtiff::display(img_thresh_mask[, , 1, 1])
ijtiff::display(img[, , 1, 1])
img_thresh_mask <- mean_stack_thresh(img, 'Huang')
ijtiff::display(img_thresh_mask[, , 1, 1])

}
