% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/assess_portmanteau.r
\name{assess_portmanteau}
\alias{assess_portmanteau}
\title{Tests the white noise assumption for a VAR model using a portmanteau test on the residuals}
\usage{
assess_portmanteau(varest)
}
\arguments{
\item{varest}{A \code{varest} model.}
}
\value{
This function returns a p-level.
}
\description{
This function tests the white noise assumption for the residuals of the endogenous variables in the specified VAR model. This function implements the portmanteau test known as the Ljung-Box test, and results are comparable with STATA's \code{wntestq}. Of the p-levels resulting from assessing the white noise assumption for the residuals of that variable, the minimum is returned.
}
\examples{
data_matrix <- matrix(nrow = 40, ncol = 3)
data_matrix[, ] <- runif(ncol(data_matrix) * nrow(data_matrix), 1, nrow(data_matrix))
colnames(data_matrix) <- c('rumination', 'happiness', 'activity')
varest <- autovarCore:::run_var(data_matrix, NULL, 1)
autovarCore:::assess_portmanteau(varest)
}

