% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_phenotype_id_from_genome_id.R
\name{get_phenotype_id_from_genome_id}
\alias{get_phenotype_id_from_genome_id}
\title{Get phenotype from genome}
\usage{
get_phenotype_id_from_genome_id(
  genome_id,
  seed_id = FALSE,
  phenotype_binary = FALSE,
  triplestore
)
}
\arguments{
\item{genome_id}{Integer or a list of integer values.}

\item{seed_id}{Integer (from 1 to 1000), a vector of integer values, or a
logical value. This integer is used for starting the pseudo-random number
generator that represents the environment experiencing a digital organism.
If a logical value is used, TRUE returns data found in all environments and
FALSE (by default) returns only distinct data regardless of the seed.}

\item{phenotype_binary}{Logical value (TRUE/FALSE) to show/hide phenotype_id
in binary notation (FALSE by default).}

\item{triplestore}{Object of class triplestore_access which manages database
access.}
}
\value{
Data frame. Columns: "seed_id" (optional), "genome_id",
"phenotype_id" "phenotype_binary" (optional).
}
\description{
Get the phenotype encoded by the genome of a digital organism
for a list of seeds used for starting the pseudo-random number generator
(i.e., a set of environments).
}
\examples{

# Create triplestore object
avidaDB <- triplestore_access$new()

# Set access options
avidaDB$set_access_options(
  url = "https://graphdb.fortunalab.org",
  user = "public_avida",
  password = "public_avida",
  repository = "avidaDB_test"
)

# Single genome
get_phenotype_id_from_genome_id(genome_id = 1, triplestore = avidaDB)

# More than one genome at seed_1
get_phenotype_id_from_genome_id(
  genome_id = c(1, 2, 3),
  seed_id = 1,
  triplestore = avidaDB
)

# More than one genome at more than one seed (e.g., seed_3 and seed_4)
get_phenotype_id_from_genome_id(
  genome_id = 1,
  seed_id = c(3, 4),
  phenotype_binary = TRUE,
  triplestore = avidaDB
)

}
