% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{aweSOMreorder}
\alias{aweSOMreorder}
\title{Reorder variables for SOM plot}
\usage{
aweSOMreorder(
  som,
  data = NULL,
  variables = NULL,
  scales = c("contrast", "range", "same"),
  values = c("mean", "median", "prototypes")
)
}
\arguments{
\item{som}{\code{kohonen} object, a SOM created by the \code{kohonen::som}
function.}

\item{data}{\code{data.frame} containing the variables to plot. This is
typically not the training data, but rather the unscaled original data, as
it is easier to read the results in the original units, and this allows to
plot extra variables not used in training. If not provided, the training
data is used.}

\item{variables}{character vector containing the names of the variables to
plot. If not provided, all columns of data will be selected. All variables
must be numeric.}

\item{scales}{character, controls the scaling of the variables on the plot.
The default "constrast" maximizes the displayed contrast by scaling the
displayed heights of each variable from minimum to maximum of the displayed
value. Alternatively, "range" uses the minimum and maximum of the
observations for each variable, and "same" displays all variables on the
same scale, using the global minimum and maximum of the data.}

\item{values}{character, the type of value to be displayed. The default
"mean" uses the observation means (from data) for each cell. Alternatively,
"median" uses the observation medians for each cell, and "prototypes" uses
the SOM's prototypes values.}
}
\value{
Returns a character vector containing the reordered variables names.
}
\description{
Reorders a set of variables for prettier display on SOM plots. Variables that
have similar variations along the cell plots while be ordered close together.
Reordering is computed from the first component of a kernel PCA performed on
the matrix of displayed values (with the variables as rows, and the cells as
columns).
}
\examples{
## Build training data
dat <- iris[, c("Sepal.Length", "Sepal.Width", "Petal.Length", "Petal.Width")]
### Scale training data
dat <- scale(dat)
## Train SOM
### Initialization (PCA grid)
init <- somInit(dat, 4, 4)
ok.som <- kohonen::som(dat, grid = kohonen::somgrid(4, 4, 'hexagonal'),
                       rlen = 100, alpha = c(0.05, 0.01),
                       radius = c(2.65,-2.65), init = init,
                       dist.fcts = 'sumofsquares')
## Reorder variables
ordered.vars <- aweSOMreorder(ok.som)
## Plot with reordered variables
aweSOMplot(som = ok.som, type = 'Circular', data = iris,
           variables= ordered.vars)
}
